﻿--VJEŽBE 03

-- Prvi korak je kreiranje baze
CREATE DATABASE BazaPoslovnihPartnera;

-- VAŽNO !!!
-- Baza jest kreirana, ali se mi nismo u nju prebacili.
-- Uvijek se prebacite u novonapravljenu bazu sa USE <naziv_baze>

USE BazaPoslovnihPartnera;

-- Zatim ćemo kreirati entitete sa svim atributima,
-- tj. tablice sa osnovnim poljima i stranim ključevima

-- Prvo kreiramo tablice bez stranih ključeva (koje imaju samo primarne ključeve),
CREATE TABLE PoslovniPartner
(	Naziv			nvarchar(max)	NOT NULL,
	Adresa			nvarchar(max)	NOT NULL,
	MB				int				NOT NULL,
	OIB				int				NOT NULL	PRIMARY KEY
);

-- Zatim kreiramo tablice sa stranim ključevima koje se na njih povezuju
-- Obaveznost stranog ključa dobijamo tako da kod definicije atributa
-- stavimo NOT NULL, inače se smatra da je veza neobavezna.
-- Strani ključ dodajemo počevši sa dijelom FOREIGN KEY po sintaksi:
-- FOREIGN KEY (polje_ili_polja_na_kojem_je_strani_kljuc_u_toj_tablici)
--		REFERENCES Tablica_u_kojoj_je_primarni_kljuc(polje_ili_polja__na_kojem_je_primarni_kljuc_u_toj_tablici)

CREATE TABLE Zaposlenik
(	
	IDZaposlenika	int				NOT NULL	PRIMARY KEY,
	Ime				nvarchar(max)	NOT NULL,
	Prezime			nvarchar(max)	NOT NULL,
	BrojTelefona	nvarchar(max)	NOT NULL,
	Mail			nvarchar(max)	NULL
);
	
--naknadno dodavanje FK polja
ALTER TABLE	Zaposlenik ADD
	OIB_Pos	int	NOT NULL
		FOREIGN KEY (OIB_Pos)
			REFERENCES PoslovniPartner (OIB);

--stavljanje FK polja odmah tijekom kreiranja tablice
CREATE TABLE Zaposlenik
(	IDZaposlenika	int				NOT NULL	PRIMARY KEY,
	Ime				nvarchar(max)	NOT NULL,
	Prezime			nvarchar(max)	NOT NULL,
	BrojTelefona	nvarchar(max)	NOT NULL,
	Mail			nvarchar(max)	NULL,
	OIB_Pos			int				NOT NULL
		FOREIGN KEY (OIB_Pos)
			REFERENCES PoslovniPartner (OIB)
);